import pandas as pd   
import pickle
import matplotlib.pyplot as plt

# Load the dataset
melbourne_housing = pd.read_csv("melb_data.csv")

flemington_prices = flemington_housing['Price']
plt.hist(flemington_prices, bins='auto', edgecolor='black')
plt.xlabel('Property Prices')
plt.ylabel('Frequency')
plt.title('Distribution of Property Prices in Flemington, Australia')

plt.savefig('./ref_result/bar_chart.png')
plt.show()
